/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.justenoughprofessions;

import com.mrbysco.justenoughprofessions.compat.CompatHelper;
import com.mrbysco.justenoughprofessions.jei.ProfessionCategory;
import com.mrbysco.justenoughprofessions.jei.ProfessionEntry;
import com.mrbysco.justenoughprofessions.jei.ProfessionWrapper;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Collection;
import java.util.LinkedList;
import java.util.function.Function;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.village.PointOfInterestType;
import net.minecraftforge.registries.ForgeRegistries;

@JeiPlugin
public class ProfessionPlugin
implements IModPlugin {
    private static final ResourceLocation UID = new ResourceLocation("justenoughprofessions", "jei_plugin");

    public ResourceLocation getPluginUid() {
        return UID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new ProfessionCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)Items.field_151166_bC), new ResourceLocation[]{ProfessionCategory.UID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)Items.field_196172_da), new ResourceLocation[]{ProfessionCategory.UID});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        LinkedList<ProfessionEntry> entries = new LinkedList<ProfessionEntry>();
        for (VillagerProfession profession : ForgeRegistries.PROFESSIONS) {
            LinkedList<ItemStack> stacks = new LinkedList<ItemStack>();
            LinkedList<ResourceLocation> knownItems = new LinkedList<ResourceLocation>();
            PointOfInterestType poiType = profession.func_221149_b();
            for (BlockState state : poiType.field_221075_w) {
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(state.func_177230_c().getRegistryName());
                if (block == null) continue;
                ItemStack stack = CompatHelper.compatCheck(new ItemStack((IItemProvider)block), profession.getRegistryName());
                ResourceLocation location = stack.func_77973_b().getRegistryName();
                if (stack.func_190926_b() || knownItems.contains(location)) continue;
                stacks.add(stack);
                knownItems.add(stack.func_77973_b().getRegistryName());
            }
            if (stacks.isEmpty()) continue;
            Int2ObjectOpenHashMap map = new Int2ObjectOpenHashMap();
            for (int i = 0; i < stacks.size(); ++i) {
                map.put(i, stacks.get(i));
            }
            entries.add(new ProfessionEntry(profession, (Int2ObjectMap<ItemStack>)map));
        }
        registration.addRecipes(ProfessionPlugin.asRecipes(entries, ProfessionWrapper::new), ProfessionCategory.UID);
    }

    private static <T, R> Collection<R> asRecipes(Collection<T> collection, Function<T, R> transformer) {
        return collection.stream().map(transformer).collect(Collectors.toList());
    }
}

